<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Eleve extends Model 
{

    protected $table = 'eleves';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function achats()
    {
        return $this->belongsToMany('App\Models\Achat');
    }

    public function photos()
    {
        return $this->morphToMany('App\Models\Medias', 'photoable');
    }

}